var app = require('express')();
var http = require('http').createServer(app);
var io = require('socket.io')(http);
var request = require('request');
const winston = require('winston');
const logger = winston.createLogger({
  level: 'info',
  format: winston.format.json(),
  defaultMeta: { service: 'user-service' },
  transports: [
    //
    // - Write all logs with level `error` and below to `error.log`
    // - Write all logs with level `info` and below to `combined.log`
    //
    new winston.transports.File({ filename: 'error.log', level: 'error' }),
    new winston.transports.File({ filename: 'combined.log' }),
  ],
});
var datetime = new Date();
app.get('/', (req, res) => {
  res.sendFile(__dirname + '/index.html');
});

io.on('connection', (socket) => {
  console.log('a user connected');
  logger.log({
    level: 'info',
    date :datetime,
    message: 'Socket connected!'
  });

  socket.on('chat message', (msg) => {
    console.log('message: ' + msg);
    io.emit('chat message', msg);
  });
  
  socket.on("passenger_join", function(data) {
    console.log("join room"+data.user_id);   
    socket.join(data.user_id);
    logger.log({
      level: 'info',
      date :datetime,
      message: 'Passenger Join Room '+data.user_id
    });
    
});
socket.on("driver_join", function(data) {
  console.log("join driver room"+data.driver_id);   
  socket.join(data.driver_id);
  logger.log({
    level: 'info',
    date :datetime,
    message: 'driver Join Room '+data.driver_id
  });
  
});
socket.on("send_job_request", function(data) {
  console.log("get_new_request"+JSON.stringify(data ));
  io.emit('get_new_request', JSON.stringify(data));
  logger.log({
    level: 'info',
    date :datetime,
    message: 'Passenger send request for driver '+JSON.stringify(data )
  });
});
  socket.on("send_driver_location", function(data) {
    console.log("send_driver_location"+data['user_id']);
   
          // console.log('http://' + ip + '/share-route-po/admin/restApi/active-taxi/get-taxi-free?COUNTRY_CODE='+geo.country);
          logger.log({
            level: 'info',
            date :datetime,
            message: 'Send Driver Location  '+JSON.stringify(data)
          });
            request.post('http://35.187.231.28/api/dashboard',
                { json : {"user_id":data.user_id, "current_lat":data.current_lat, "current_lng":data.current_lng}}, function(err,httpResponse,body){
                if(!err)
                {
                
              console.log("get arriving details"+JSON.stringify(body));
                  //  io.emit("get_arriving_details", body);
                  logger.log({
                    level: 'info',
                    date :datetime,
                    message: 'Passenger enter in Socket/passenger id  '+data.user_id
                  });
                  io.to(data.user_id).emit('get_arriving_details',JSON.stringify(body));
                  logger.log({
                    level: 'info',
                    date :datetime,
                    message: 'Passenger will Get Arriving details'+JSON.stringify(body)
                  });
                  //  io.to(data.driver_id).emit('get_current_progress_task',JSON.stringify(body));
                   
                }
                else
                {
                    console.log(err);
                }
            });
       

});
socket.on("send_driver_socket", function(data) {
  console.log("send_driver_socket"+data['driver_id']);
 
        // console.log('http://' + ip + '/share-route-po/admin/restApi/active-taxi/get-taxi-free?COUNTRY_CODE='+geo.country);
        logger.log({
          level: 'info',
          date :datetime,
          message: 'Send Driver Current location for getting current task'+JSON.stringify(data)
        });
          request.post('http://35.187.231.28/api/dashboard-driver',
              { json : {"driver_id":data.driver_id, "current_lat":data.current_lat, "current_lng":data.current_lng}}, function(err,httpResponse,body){
              if(!err)
              {
              
            console.log("get arriving details"+JSON.stringify(body));
                //  io.emit("get_arriving_details", body);
               // io.to(data.user_id).emit('get_arriving_details',JSON.stringify(body));
               logger.log({
                level: 'info',
                date :datetime,
                message: 'Driver enter in socket  '+data.driver_id
              });
                  io.to(data.driver_id).emit('get_current_progress_task',JSON.stringify(body));
                  logger.log({
                    level: 'info',
                    date :datetime,
                    message: ' Driver will get the current progress task'+JSON.stringify(body)
                  });
                 
              }
              else
              {
                  console.log(err);
              }
          });
     

});
socket.on("send_pending_feedback_request", function(data) {
  console.log("send_pending_feedback_request"+data['user_id']);
 
  logger.log({
    level: 'info',
    date :datetime,
    message: ' Send Pending feedback request to passenger : '+data['user_id']
  });
          request.post('http://35.187.231.28/api/pending-review-booking',
              { json : {"user_id":data.user_id}}, function(err,httpResponse,body){
              if(!err)
              {
              
            console.log("get pending reviews"+JSON.stringify(body));
                  logger.log({
                    level: 'info',
                    date :datetime,
                    message: 'Passenger enter in socket  '+data.user_id
                  });
                  io.to(data.user_id).emit('get_pending_reviews',JSON.stringify(body));
                  logger.log({
                    level: 'info',
                    date :datetime,
                    message: 'Passenger will get pending reviews : '+JSON.stringify(body)
                  });
              }
              else
              {
                  console.log(err);
              }
          });
     

});
socket.on("send_driver_current_location", function(data) {
  console.log("send_driver_current_location"+JSON.stringify(data));

  logger.log({
    level: 'info',
    date :datetime,
    message: 'Send Driver current location for getting coordinates : '+JSON.stringify(data)
  });
        request.post('http://35.187.231.28/api/pass-coordinates',
              { json : {
                "current_lat": data.current_lat,
                "current_lng": data.current_lng,
                "booking_id":  data.booking_id,
                "user_id" :  data.user_id,
                "type":data.type
            }}, function(err,httpResponse,body){
              if(!err)
              {
              
            console.log("send_to_passenger"+JSON.stringify(body));
               
                  logger.log({
                    level: 'info',
                    date :datetime,
                    message: 'Passenger enter in socket  '+data.user_id
                  });
                  io.to(data.user_id).emit('send_to_passenger',JSON.stringify(body));
                  logger.log({
                    level: 'info',
                    date :datetime,
                    message: 'Passenger get coordinates : '+JSON.stringify(body)
                  });
              }
              else
              {
                  console.log(err);
              }
          });
     

});
  socket.on("send_booking_request", function(array) {
   console.log(JSON.stringify(array));
   logger.log({
    level: 'info',
    date :datetime,
    message: 'Send Booking Request Broadcast: '+JSON.stringify(array)
  });
   io.emit('get_booking_response', JSON.stringify(array));
   logger.log({
    level: 'info',
    date :datetime,
    message: 'Get Booking Request to all driver : '+JSON.stringify(array)
  });
          });
  socket.on('disconnect', () => {
    console.log('user disconnected');
    logger.log({
      level: 'info',
      date :datetime,
      message: 'Socket Disconnected '
    });
    
  });
});

http.listen(2000, () => {
  console.log('listening on *:2000');
  logger.log({
    level: 'info',
    date :datetime,
    message: 'listening on *:2000'
  });
});