var app = require('express')();
var http = require('http').createServer(app);
var io = require('socket.io')(http);
var request = require('request');

app.get('/', (req, res) => {
  res.sendFile(__dirname + '/index.html');
});

io.on('connection', (socket) => {
  console.log('a user connected');
  socket.on('chat message', (msg) => {
    console.log('message: ' + msg);
    io.emit('chat message', msg);
  });
  
  socket.on("passenger_join", function(data) {
    console.log("join room"+data.user_id);   
    socket.join(data.user_id);
    
});
socket.on("driver_join", function(data) {
  console.log("join driver room"+data.driver_id);   
  socket.join(data.driver_id);
  
});
socket.on("send_job_request", function(data) {
  console.log("get_new_request"+JSON.stringify(data ));
  io.emit('get_new_request', JSON.stringify(data));
});
  socket.on("send_driver_location", function(data) {
    console.log("send_driver_location"+data['user_id']);
   
          // console.log('http://' + ip + '/share-route-po/admin/restApi/active-taxi/get-taxi-free?COUNTRY_CODE='+geo.country);

            request.post('http://35.223.245.213/api/dashboard',
                { json : {"user_id":data.user_id, "current_lat":data.current_lat, "current_lng":data.current_lng}}, function(err,httpResponse,body){
                if(!err)
                {
                
              console.log("get arriving details"+JSON.stringify(body));
                  //  io.emit("get_arriving_details", body);
                  io.to(data.user_id).emit('get_arriving_details',JSON.stringify(body));
                  //  io.to(data.driver_id).emit('get_current_progress_task',JSON.stringify(body));
                   
                }
                else
                {
                    console.log(err);
                }
            });
       

});
socket.on("send_driver_socket", function(data) {
  console.log("send_driver_socket"+data['driver_id']);
 
        // console.log('http://' + ip + '/share-route-po/admin/restApi/active-taxi/get-taxi-free?COUNTRY_CODE='+geo.country);

          request.post('http://35.223.245.213/api/dashboard-driver',
              { json : {"driver_id":data.driver_id, "current_lat":data.current_lat, "current_lng":data.current_lng}}, function(err,httpResponse,body){
              if(!err)
              {
              
            console.log("get arriving details"+JSON.stringify(body));
                //  io.emit("get_arriving_details", body);
               // io.to(data.user_id).emit('get_arriving_details',JSON.stringify(body));
                  io.to(data.driver_id).emit('get_current_progress_task',JSON.stringify(body));
                 
              }
              else
              {
                  console.log(err);
              }
          });
     

});
socket.on("send_pending_feedback_request", function(data) {
  console.log("send_pending_feedback_request"+data['user_id']);
 
        // console.log('http://' + ip + '/share-route-po/admin/restApi/active-taxi/get-taxi-free?COUNTRY_CODE='+geo.country);

          request.post('http://35.223.245.213/api/pending-review-booking',
              { json : {"user_id":data.user_id}}, function(err,httpResponse,body){
              if(!err)
              {
              
            console.log("get pending reviews"+JSON.stringify(body));
                //  io.emit("get_arriving_details", body);
                  io.to(data.user_id).emit('get_pending_reviews',JSON.stringify(body));
              }
              else
              {
                  console.log(err);
              }
          });
     

});
socket.on("send_driver_current_location", function(data) {
  console.log("send_driver_current_location"+JSON.stringify(data));
 
        // console.log('http://' + ip + '/share-route-po/admin/restApi/active-taxi/get-taxi-free?COUNTRY_CODE='+geo.country);

        io.to(data.user_id).emit('send_to_passenger',JSON.stringify(data));
        //io.emit("send_to_passenger", JSON.stringify(data));
               //   io.emit("send_to_passenger", JSON.stringify(data));
     

});
  socket.on("send_booking_request", function(array) {
   console.log(JSON.stringify(array));
   io.emit('get_booking_response', JSON.stringify(array));
          });
  socket.on('disconnect', () => {
    console.log('user disconnected');
  });
});

http.listen(2000, () => {
  console.log('listening on *:2000');
});